#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brParam.h"
#include "wx/statline.h"
enum {
 ID_NEW=8450,
 ID_EDIT,
 ID_DELETE,
 ID_UP,
 ID_DOWN,
 ID_LIST
};

enum { C_DATE=0,C_MONEY,C_NUMBER,C_QUICKPICK };

//IMPLEMENT_DYNAMIC_CLASS(brParam,wxPanel)
BEGIN_EVENT_TABLE(brParam,wxPanel)
EVT_BUTTON(ID_NEW,brParam::OnNew)
EVT_BUTTON(ID_EDIT,brParam::OnEdit)
EVT_BUTTON(ID_DELETE,brParam::OnDelete)
EVT_BUTTON(ID_UP,brParam::OnUp)
EVT_BUTTON(ID_DOWN,brParam::OnDown)
EVT_LISTBOX(ID_LIST,brParam::OnSelect)
EVT_LISTBOX_DCLICK(ID_LIST,brParam::OnEdit)
END_EVENT_TABLE()


brParam::brParam(wxWindow *parent,BOLTdb *db, RECORD_ID recordId):
 wxPanel(parent,-1)
{
	 this->db=db;
	 this->recordId=recordId;
	SetFont(parent->GetFont());
SetBackgroundColour(parent->GetBackgroundColour());
wxBoxSizer *topSizer;
topSizer=new wxBoxSizer(wxVERTICAL);
topSizer->Add(new wxStaticText(this,-1,"Parameters"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);
wxBoxSizer *bSizer=new wxBoxSizer(wxHORIZONTAL);
wxBoxSizer *vSizer=new wxBoxSizer(wxHORIZONTAL);

bSizer->Add(new wxListBox(this,ID_LIST),1,wxEXPAND|wxALL,2);
vSizer->Add(new wxButton(this,ID_UP,"Up"),0,wxALIGN_CENTER|wxALL,2);
vSizer->Add(new wxButton(this,ID_DOWN,"Down"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(vSizer,0,wxEXPAND);
topSizer->Add(bSizer,1,wxEXPAND);

bSizer=new wxBoxSizer(wxHORIZONTAL);
bSizer->Add(new wxButton(this,ID_NEW,"New"),0,wxALIGN_CENTER|wxALL,2);
bSizer->Add(new wxButton(this,ID_EDIT,"Edit"),0,wxALIGN_CENTER|wxALL,2);
bSizer->Add(new wxButton(this,ID_DELETE,"Delete"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,2);
//SetAutoLayout(TRUE);
SetSizerAndFit(topSizer);
FillList();
 };

void brParam::OnNew(wxCommandEvent & event)
{
	char *tmp;
	wxString tStr,tStr2;
	RECORD_ID newId;

	newId=db->NewRecord("ReportParameters");
	db->SetValue("ReportParameters","reportId",newId,recordId);
	db->SetValue("ReportParameters","name",newId,"'New Parameter'");
	tStr.Printf("select if(MAX(runOrder) is null,0,MAX(runOrder))+1 from ReportParameters where reportId=%u",recordId);
	tStr2=db->GetQueryValue(tStr.c_str());
	db->SetValue("ReportParameters","runOrder",newId,tStr2.c_str());
	brParamEditor *prPE;
	prPE=new brParamEditor(this,db,newId);
	prPE->Destroy();
	FillList();

};

void brParam::OnEdit(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();

	brParamEditor *prPE;
	prPE=new brParamEditor(this,db,aId[sel]);
	prPE->Destroy();
	FillList();

};

void brParam::OnDelete(wxCommandEvent & event)
{
	wxListBox *list;
	if (wxMessageBox("Are you sure you would like to delete this parameter ?","Confirm Delete",wxYES_NO,this)==wxNO)
		{ return; }
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<0) || (!aId[sel])) { return; }
	//collapse run order
	char *tmp=db->GetValue("ReportParameters","runOrder",(RECORD_ID)aId[sel]);
	wxString tStr;
	tStr.Printf("update ReportParameters set runOrder=runOrder-1 where reportId=%u and runOrder>%s",recordId,tmp);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr.Printf("delete from ReportParameters where id=%u",
			aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();

};

void brParam::OnUp(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<=0) || (!aId[sel])) { return; }

	wxString tStr,tStr2;
	tStr.Printf("update ReportParameters set runorder=runorder-1 where id=%u",aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr2=db->GetValue("ReportParameters","runOrder",(RECORD_ID)aId[sel]);
	tStr.Printf("update ReportParameters set runorder=runorder+1 where runOrder=%s and reportId=%s and id!=%u",
		tStr2.c_str(),
		(RECORD_ID)db->GetValue("ReportParameters","reportId",aId[sel]),
		(RECORD_ID)aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
	list->SetSelection(sel-1);
	OnSelect(wxCommandEvent(0,0));

};

void brParam::OnDown(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<0) || (!aId[sel])) { return; }

	wxString tStr,tStr2;
	tStr.Printf("update ReportParameters set runorder=runorder+1 where id=%u",aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr2=db->GetValue("ReportParameters","runOrder",(RECORD_ID)aId[sel]);
	tStr.Printf("update ReportParameters set runorder=runorder-1 where runOrder=%s and reportId=%s and id!=%u",
		tStr2.c_str(),
		(RECORD_ID)db->GetValue("ReportParameters","reportId",(RECORD_ID)aId[sel]),
		(RECORD_ID)aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
	list->SetSelection(sel+1);
	OnSelect(wxCommandEvent(0,0));
};

void brParam::FillList()
{
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr;
	wxListBox *list;
	int cSel;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	cSel=list->GetSelection();
	list->Clear(); aId.Empty();
	tStr.Printf("select id,concat(name,' : ',\
		if (paramType is null,'<unknown type>',''),\
		if (paramType = 0,'Date',''), \
		if (paramType = 1,'Money',''), \
		if (paramType = 2,'Number',''), \
		if (paramType = 3,if (paramClass is null,'?',paramClass),'') \
		) from ReportParameters where reportId=%u order by runOrder",recordId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry))
		{
			tmp=db->FetchQueryResult(qry,row,0);
			tStr=db->FetchQueryResult(qry,row,1);
			list->Append(tStr);
			aId.Add(atoi(tmp));
		}
		db->FreeQuery(qry);
	}
//	list->SetSelection(0,FALSE);
	if (cSel>=list->Number())
		{ cSel=list->Number()-1; };
	if (cSel>-1)
		list->SetSelection(cSel,TRUE);
	OnSelect(wxCommandEvent(0,0));
}

void brParam::OnSelect(wxCommandEvent &event)
{
wxListBox *list;
int max,sel;
list=(wxListBox *)this->FindWindow(ID_LIST);
max=list->Number()-1;
sel=list->GetSelection();

this->FindWindow(ID_NEW)->Enable(TRUE);
this->FindWindow(ID_EDIT)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_DELETE)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_UP)->Enable((sel>0)&&(sel<=max));
this->FindWindow(ID_DOWN)->Enable((sel>=0)&&(sel<max));
}

enum { ID_PE_ITEM=7000,
ID_PE_CHOICE,
ID_PE_CLASS };


//IMPLEMENT_DYNAMIC_CLASS(brParamEditor,wxDialog)
BEGIN_EVENT_TABLE(brParamEditor,wxDialog)
EVT_TEXT(ID_PE_ITEM,brParamEditor::OnText)
EVT_CHOICE(ID_PE_CHOICE,brParamEditor::OnChoice)
EVT_CHOICE(ID_PE_CLASS,brParamEditor::OnClass)
END_EVENT_TABLE()

brParamEditor::brParamEditor(wxWindow *parent,BOLTdb *db,RECORD_ID recordId) :
wxDialog(parent,-1,"brParam Editor",wxDefaultPosition)
{
	this->db=db;
	this->recordId=recordId;
		SetFont(parent->GetFont());

	wxBoxSizer *topSizer;
	wxBoxSizer *hSizer;

		wxString choices[]={wxString("Date"),
		wxString("Money"),
		wxString("Number"),
		wxString("QuickPick")};
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr;
	bcChoice *tChoice;


	topSizer=new wxBoxSizer(wxVERTICAL);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(new wxStaticText(this,-1,"Name"),0,wxALL,5);
	hSizer->Add(new bcItem(this,ID_PE_ITEM,"reportParameters","name",db,recordId));
	topSizer->Add(hSizer,0,wxEXPAND|wxALL,5);
	topSizer->Add(new wxStaticText(this,-1,"Prompt"),1,wxALIGN_RIGHT|wxALL,7);
	hSizer=new wxBoxSizer(wxHORIZONTAL);
	hSizer->Add(tChoice=new bcChoice(this,ID_PE_CHOICE,"Parameter Type",4,choices,"reportParameters","paramType",db,recordId,1),0,wxEXPAND|wxALL,5);
	cClass=new bcChoiceText(this,ID_PE_CLASS,"Parameter Class",0,choices,"reportParameters","paramClass",db,recordId,1);
	
//fill quickPick Classes
	tStr="select class from quickpicks group by class;";
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry))
		{
			tStr=db->FetchQueryResult(qry,row,0);
			cClass->Append(tStr);
		}
		db->FreeQuery(qry);
	}
	cClass->Refresh();

	this->cClass->Enable(tChoice->GetSelection()==C_QUICKPICK);

	hSizer->Add(cClass,0,wxEXPAND|wxALL,5);
	hSizer->Add(new bcItem(this,ID_PE_ITEM,"reportParameters","prompt",db,recordId,wxDefaultValidator,wxTE_MULTILINE),1,wxEXPAND|wxALL,5);
	topSizer->Add(hSizer,0,wxEXPAND);
	topSizer->Add(new wxButton(this,wxID_CANCEL,"Done"),0,wxALIGN_CENTER|wxALL,5);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );
	Centre( wxBOTH );
	ShowModal();
};

void brParamEditor::OnText(wxCommandEvent &event)
{
	bcItem *item;
	item = (bcItem *)event.GetEventObject();
	if (item) { item->OnEdit();}
}

void brParamEditor::OnChoice(wxCommandEvent &event)
{
bcChoice::OnRadioBox(event);
if (event.GetSelection()==C_QUICKPICK)
{
	this->cClass->Enable(TRUE);
} else
{
	this->cClass->Enable(FALSE);
}
}

void brParamEditor::OnClass(wxCommandEvent &event)
{
bcChoiceText::OnRadioBox(event);
}